/***************************************************************************
 *
 * Copyright (c) 2013 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include <cstdlib>
#include <iostream>

#include "InputDeviceConfiguration.h"
#include "Log.h"

using namespace std;
using namespace LayerManagerCalibration;

int main(int argc, char **argv)
{
    if (argc < 2)
    {
        cerr << endl;
        cerr << "Usage: " << argv[0] << " CONFIG_FILE_PATH" << endl;
        cerr << endl;
        exit(1);
    }

    Log::getInstance()->setFileLogLevel(LOG_DEBUG);
    Log::getInstance()->setConsoleLogLevel(LOG_DEBUG);
    Log::getInstance()->setDLTLogLevel(LOG_DEBUG);

    InputDeviceConfiguration config;

    if (!config.parseFile(argv[1]))
    {
        cerr << "Failed to parse device configuration file \""
             << argv[1] << "\"" << endl;
    }
    else
    {
        const list<string*>& deviceNames = config.getDeviceNames();
        list<string*>::const_iterator iter;

        for (iter = deviceNames.begin();
             iter != deviceNames.end();
             iter++)
        {
            cout << endl;
            cout << "Device name: " << **iter << endl;
            cout << endl;
        }
    }

    Log::closeInstance();

    return 0;
}
